/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.fluid_generators;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.fluid_generators.IFluidGenerator;
import com.ordana.immersive_weathering.data.position_tests.IPositionRuleTest;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3825;
import net.minecraft.class_6880;

public class SelfFluidGenerator
implements IFluidGenerator {
    public static final Codec<SelfFluidGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2378.field_11154.method_39673().fieldOf("fluid").forGetter(SelfFluidGenerator::getFluid), (App)IFluidGenerator.FluidType.CODEC.optionalFieldOf("fluid_type", (Object)IFluidGenerator.FluidType.BOTH).forGetter(SelfFluidGenerator::getFluidType), (App)class_2680.field_24734.fieldOf("generate").forGetter(SelfFluidGenerator::getGrowth), (App)AdjacentBlocks.CODEC.fieldOf("adjacent_blocks").forGetter(SelfFluidGenerator::getAdjacentBlocksCondition), (App)IPositionRuleTest.CODEC.optionalFieldOf("additional_target_check").forGetter(SelfFluidGenerator::getPositionTests), (App)Codec.INT.optionalFieldOf("priority", (Object)0).forGetter(SelfFluidGenerator::getPriority)).apply((Applicative)instance, SelfFluidGenerator::new));
    public static final IFluidGenerator.Type<SelfFluidGenerator> TYPE = new IFluidGenerator.Type<SelfFluidGenerator>(CODEC, "target_self");
    private final class_3611 fluid;
    private final IFluidGenerator.FluidType fluidType;
    private final class_2680 growth;
    private final Optional<IPositionRuleTest> positionTests;
    private final int priority;
    private final AdjacentBlocks adjacentBlocksCondition;

    public SelfFluidGenerator(class_3611 fluid, IFluidGenerator.FluidType fluidType, class_2680 growth, AdjacentBlocks adjacentBlocks, Optional<IPositionRuleTest> positionRuleTests, int priority) {
        this.fluid = fluid;
        this.fluidType = fluidType;
        this.growth = growth;
        this.adjacentBlocksCondition = adjacentBlocks;
        this.positionTests = positionRuleTests;
        this.priority = priority;
    }

    @Override
    public IFluidGenerator.FluidType getFluidType() {
        return this.fluidType;
    }

    @Override
    public IFluidGenerator.Type<?> getType() {
        return TYPE;
    }

    @Override
    public class_3611 getFluid() {
        return this.fluid;
    }

    public class_2680 getGrowth() {
        return this.growth;
    }

    public Optional<IPositionRuleTest> getPositionTests() {
        return this.positionTests;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public AdjacentBlocks getAdjacentBlocksCondition() {
        return this.adjacentBlocksCondition;
    }

    @Override
    public Optional<class_2338> tryGenerating(List<class_2350> possibleFlowDir, class_2338 pos, class_1937 level, Map<class_2350, class_2680> neighborCache) {
        if (!this.adjacentBlocksCondition.isMet(possibleFlowDir, pos, level, neighborCache, this.positionTests)) {
            return Optional.empty();
        }
        if (pos != null) {
            level.method_8501(pos, this.growth);
            return Optional.of(pos);
        }
        return Optional.empty();
    }

    public static class AdjacentBlocks {
        public static final Codec<AdjacentBlocks> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_3825.field_25012.listOf().optionalFieldOf("sides", List.of()).forGetter(a -> a.sidesBlocks), (App)class_3825.field_25012.listOf().optionalFieldOf("any", List.of()).forGetter(a -> a.anyBlocks), (App)class_3825.field_25012.optionalFieldOf("up").forGetter(a -> Optional.ofNullable(a.upBlock)), (App)class_3825.field_25012.optionalFieldOf("down").forGetter(a -> Optional.ofNullable(a.downBlock))).apply((Applicative)instance, AdjacentBlocks::new)).comapFlatMap(arg -> {
            if (arg.sidesBlocks.isEmpty() && arg.anyBlocks.isEmpty() && arg.upBlock == null && arg.downBlock == null) {
                return DataResult.error((String)"Adjacent Blocks must contain at least one predicate");
            }
            return DataResult.success((Object)arg);
        }, Function.identity());
        private final List<class_3825> anyBlocks;
        private final List<class_3825> sidesBlocks;
        private final class_3825 upBlock;
        private final class_3825 downBlock;

        public AdjacentBlocks(List<class_3825> sidesBlocks, List<class_3825> anyBlocks, Optional<class_3825> upBlock, Optional<class_3825> downBlock) {
            this.sidesBlocks = sidesBlocks;
            this.anyBlocks = anyBlocks;
            this.upBlock = upBlock.orElse(null);
            this.downBlock = downBlock.orElse(null);
        }

        public boolean isMet(List<class_2350> possibleFlowDir, class_2338 pos, class_1937 level, Map<class_2350, class_2680> neighborCache, Optional<IPositionRuleTest> extraCheck) {
            boolean atLeastOnceSuccess;
            Supplier b = Suppliers.memoize(() -> level.method_23753(pos));
            for (class_3825 r : this.anyBlocks) {
                atLeastOnceSuccess = false;
                for (class_2350 d : class_2350.values()) {
                    class_2338 side = pos.method_10093(d);
                    class_2680 state = neighborCache.computeIfAbsent(d, p -> level.method_8320(side));
                    if (!r.method_16768(state, level.field_9229) || extraCheck.isPresent() && !extraCheck.get().test((java.util.function.Supplier<class_6880<class_1959>>)b, side, level)) continue;
                    atLeastOnceSuccess = true;
                    break;
                }
                if (atLeastOnceSuccess) continue;
                return false;
            }
            for (class_3825 r : this.sidesBlocks) {
                atLeastOnceSuccess = false;
                for (class_2350 d : possibleFlowDir) {
                    class_2338 side;
                    class_2680 state;
                    if (!d.method_10166().method_10179() || !r.method_16768(state = neighborCache.computeIfAbsent(d, arg_0 -> AdjacentBlocks.lambda$isMet$8(level, side = pos.method_10093(d), arg_0)), level.field_9229) || extraCheck.isPresent() && !extraCheck.get().test((java.util.function.Supplier<class_6880<class_1959>>)b, side, level)) continue;
                    atLeastOnceSuccess = true;
                    break;
                }
                if (atLeastOnceSuccess) continue;
                return false;
            }
            if (this.upBlock != null && this.testFails(this.downBlock, pos, level, neighborCache, extraCheck, (java.util.function.Supplier<class_6880<class_1959>>)b, class_2350.field_11036)) {
                return false;
            }
            return this.downBlock == null || !this.testFails(this.downBlock, pos, level, neighborCache, extraCheck, (java.util.function.Supplier<class_6880<class_1959>>)b, class_2350.field_11033);
        }

        private boolean testFails(class_3825 test, class_2338 pos, class_1937 level, Map<class_2350, class_2680> neighborCache, Optional<IPositionRuleTest> extraCheck, java.util.function.Supplier<class_6880<class_1959>> biome, class_2350 dir) {
            class_2338 target = pos.method_10093(dir);
            class_2680 state = neighborCache.computeIfAbsent(dir, p -> level.method_8320(target));
            if (!test.method_16768(state, level.field_9229)) {
                return true;
            }
            return extraCheck.isPresent() && !extraCheck.get().test(biome, target, level);
        }

        private static /* synthetic */ class_2680 lambda$isMet$8(class_1937 level, class_2338 side, class_2350 p) {
            return level.method_8320(side);
        }
    }
}

